
;ͻ
;                                                                          
; EOS.INC (Tabs : 13 21 29 37)                                             
;                                                                          
;ͼ

;ͻ
;                                                                          
; EOS Variables                                                            
;                                                                          
;ͼ


;
; MASM Declarations
;

IFNDEF  ??VERSION
     Global EQU  Externdef
ENDIF

;
; Versions
;

Ver_EOS             Equ db '2.06'
Ver_Diamond         Equ db '1.10'
Ver_Fli32           Equ db '1.02'
Ver_Vesa            Equ db '1.00'
Ver_Snap            Equ db '1.00'
Ver_Debug           Equ db '0.50'
Ver_Joystick        Equ db '0.60'


;
; Key_Map
;

All         = 0
Escape      = 1
Return      = 28
Space       = 57
Left        = 75
Right       = 77
Up          = 72
Down        = 80
Plus        = 78
Moins       = 74
Ctrl        = 29
Num_1       = 79
Num_2       = 80
Num_3       = 81
Num_4       = 75
Num_5       = 76
Num_6       = 77
Num_7       = 71
Num_8       = 72
Num_9       = 73
Num_0       = 82
Key_1       = 02
Key_2       = 03
Key_3       = 04
Key_4       = 05
Key_5       = 06
Key_6       = 07
Key_7       = 08
Key_8       = 09
Key_9       = 10
Key_0       = 11
Key_A       = 16
Key_Z       = 17
Key_E       = 18
Key_R       = 19
Key_T       = 20
Key_Y       = 21
Key_U       = 22
Key_I       = 23
Key_O       = 24
Key_P       = 25
Key_Q       = 30
Key_S       = 31
Key_D       = 32
Key_F       = 33
Key_G       = 34
Key_H       = 35
Key_J       = 36
Key_K       = 37
Key_L       = 38
Key_M       = 39
Key_W       = 44
Key_X       = 45
Key_C       = 46
Key_V       = 47
Key_B       = 48
Key_N       = 49
Key_F1      = 59
Key_F2      = 60
Key_F3      = 61
Key_F4      = 62
Key_F5      = 63
Key_F6      = 64
Key_F7      = 65
Key_F8      = 66
Key_F9      = 67
Key_F10     = 68
Key_F11     = 87
Key_F12     = 88

;
; Others
;

Impossible  = 0     ; For the cut and paste (Ever 0)

On          = 1
Off         = 0

vbl         = 1


Int_Val_EOS = 61h
Int_EOS     Equ Int Int_Val_EOS

B Equ Byte Ptr
W Equ Word Ptr
D Equ Dword Ptr
F Equ Fword Ptr
O Equ Offset

RAW         equ 01h
XMS         equ 02h
VCPI        equ 04h
DPMI        equ 08h


;ͻ
;                                                                          
; EOS Macros                                                               
;                                                                          
;ͼ


Color       macro c,x,y,z
	    if vbl
            pushf
	push dx
	push ax
	mov dx,3c8h
	mov ax,c
	out dx,al
	inc dx
	mov ax,x
	out dx,al
	mov ax,y
	out dx,al
	mov ax,z
	out dx,al
	pop ax
	pop dx
	popf
	    endif
	endm

Send        macro value,x,y
            pushad
            pushf
            mov edx,value
            mov bx,x
            mov cx,y
            mov ah,Set_Value_Mono
            Int_EOS
            popf
            popad
            endm

Get_Param   macro name
local @@no_path
            mov esi,cs:[PSP_Addr]
            add esi,80h
            mov cl,byte ptr [esi]
            and ecx,0ffh
            mov byte ptr [esi],0
            je @@no_path
            mov edi,offset name
            add esi,2
            rep movsb
            mov Byte ptr es:[edi-1],0
@@no_path:
            endm


;ͻ
;                                                                          
; EOS Functions                                                            
;                                                                          
;ͼ


;ͻ
;                                                                          
;                                System                                    
;                                                                          
;ͼ


;Ŀ
;Exit Error   Restore initial Video mode , interrupts , free all reserved  
;             memory ,stop music if played and exit (with error code 1)    
;             with a error message                                         
;                                                                          
;In :                                                                      
;        AH = Exit_Error                                                   
;    DS:EDX = Offset message to display                                    
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Exit_Error = 1h
If Impossible
            mov ah,Exit_Error
            mov edx,Offset Error_Txt
            Int_EOS
EndIf


;Ŀ
;Use Int 08   Use Int 08 (IRQ 0) to count frame rate and have a stable     
;             vertical retrace (important when using the Sound Blaster)    
;In :                                                                      
;        AH = Use_Int_08                                                   
;        BX = On Enable Int 08                                             
;           = Off Disable Int 08 (Default setting)                         
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Use_Int_08          = 02h
If Impossible
            mov ah,Use_Int_08
            mov bx,On
            Int_EOS
EndIf


;Ŀ
;Synchro Int 08   Do a Synchronization of Int 08 (use when changing video  
;                 mode). Use_Int_08 must be On                             
;In :                                                                      
;        AH = Synchro_Int_08                                               
;                                                                          
;Out :                                                                     
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Synchro_Int_08      = 03h
If Impossible
            mov ax,13h
            DosInt 10h
            mov ah,Synchro_Int_08
            Int_EOS
EndIf


;Ŀ
;Use Int 09   Use Internal Keyboard handler to use keyboard                
;                                                                          
;In :                                                                      
;        AH = Use_Int_09                                                   
;        BX = On Enable Int 09                                             
;           = Off Disable Int 09 (Default setting)                         
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;Example :                                                                 
;                                                                          
;                                                                          
;                                                                          
;

Global Key_Map      : Byte  ; Offset of the Key_Mapping

Use_Int_09          = 04h
If Impossible
            mov ah,Use_Int_09
            mov bx,On
            Int_EOS

            ...

@@Pause:                            ; Test if key pressed
            cmp Key_Map[All],Off
            je @@Pause
            mov Key_Map[All],Off

            ...

@@Pause:                            ; Test if the Esc key is pressed
            cmp Key_Map[Escape],On  ; Actually
            jne @@Pause

            ...

@@Pause:                            ; Test if the ESC key have been pressed
            cmp Key_Map[All],Escape
            jne @@Pause
EndIf


;Ŀ
;Restore Video Mode   Restore the inital video which is be active at the   
;                     start of the program                                 
;                                                                          
;In :                                                                      
;        AH = Restore_Video_Mode                                           
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Restore_Video_Mode  = 07h
If Impossible
            mov ah,Restore_Video_Mode
            Int_EOS
EndIF

;Ŀ
;Detect Windows       Detect If Windows is running                         
;                                                                          
;In :                                                                      
;        AH = Detect_Windows                                               
;                                                                          
;Out :                                                                     
;        AL = Windows version                                              
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Detect_Windows      = 0Ah
Windows_3x          = 3
Windows_95          = 4
If Impossible
            lea edx,Windows_Txt
            mov ah,Detect_Windows
            Int_EOS
            or al,al
            jnz Error

            ...

Windows_Txt         db "     Sorry, but this program can not run under Microsoft Windows (tm)",13,10,36
EndIF


;ͻ
;                                                                          
;                                 Files                                    
;                                                                          
;ͼ


;Ŀ
;Load Internal file   Load a file which is link with LLINK                 
;                     if the file is not present the program stop and      
;                     display a error message                              
;                                                                          
;In :                                                                      
;        AH = Load_Internal_File                                           
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Zero_Sel)              
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_Internal_File  = 10h
If Impossible
            mov ah,Load_Internal_File
            mov edx,O File_name
            Int_EOS
            mov [File_Buffer],eax
EndIf


;Ŀ
;Load External file   Load a external file and uncompress it if it has     
;                     been compress with Diet 1.44                         
;                                                                          
;In :                                                                      
;        AH = Load_External_File                                           
;       EDX = Offset of file name                                          
;                                                                          
;Out :                                                                     
;       Carry = 0                                                          
;        All done                                                          
;       EAX = Logical address of buffer (work with Data32_Sel)             
;       ECX = Number of bytes read                                         
;       ESI = Physical address of buffer (work with Zero_Sel)              
;                                                                          
;                                                                          
;       Carry = 1                                                          
;        Error                                                             
;       EAX = 1 File Not Found                                             
;             2 Not Enough Memory                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_External_File  = 11h
If Impossible
            mov ah,Load_External_File
            mov edx,O File_name
            Int_EOS
            jc Error_File
            mov [File_Buffer],eax
EndIf


;Ŀ
;Write External File  Save a File on a Disk                                
;                                                                          
;Entree :                                                                  
;        AH = Write_External_File                                          
;       ECX = Size Of File                                                 
;       EDX = Offset of file name                                          
;       ESI = Buffer address                                               
;                                                                          
;Sortie :                                                                  
;       Carry = 0                                                          
;        Tout Va Bien                                                      
;                                                                          
;       Carry = 1                                                          
;        Erreur  Can't write file                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Write_External_File  = 14h
If Impossible
            mov ah,Write_External_File
            mov edx,O File_name
            mov esi,[Buffer]
            mov ecx,[Size_Buffer]
            Int_EOS
            jc Error_File
EndIf


;ͻ
;                                                                          
;                              Synchronization                             
;                                                                          
;ͼ


;Ŀ
;Wait Vbl   Wait the vertical retrace                                      
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;       EAX = Number of Vbl lost since the last call                       
;             (work only when the Int 08 is on)                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Wait_vbl            = 20h
If Impossible
            mov ah,Wait_Vbl
            Int_EOS
EndIf


;ͻ
;                                                                          
;                              Diamond Player                              
;                                                                          
;ͼ


;
; Diamond Player Declaration
;

  Global    Diamond_Player : Far

  No_Card           = 0
  Sb                = 2
  Sb_Pro            = 3
  Sb_16             = 4
  Sb_32             = 5
  Gravis            = 10h
  Gravis_Max        = 11h
  Gravis_Ace        = 12h

;Ŀ
;Detect Sound Card   Detect with the environment varialble the sound       
;                    card installed                                        
;                                                                          
;In :                                                                      
;        AH = Detect_Sound_Card                                            
;        BX = 0  Find Best One (First Gus and SB)                          
;           = 1  Force SB Search                                           
;        CX = 1  Display result of Searching                               
;                                                                          
;Out :                                                                     
;        AX = 0  No_Card                                                   
;           = 2  Sound Blaster                                             
;           = 3  Sound Blaster Pro                                         
;           = 4  Sound Blaster 16                                          
;           = 5  Sound Blaster Awe 32                                      
;           = 10h  Gus                                                     
;           = 11h  Gus Max                                                 
;           = 12h  Gus Ace                                                 
;        BX = Port Gus ou Sb                                               
;        CX = Irq Gus ou SB                                                
;        DX = Dma Gus ou SB                                                
;        SI = Dsp Version (For Sb) ou                                      
;             Size of RAM of the Gravis                                    
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Detect_Sound_Card   = 30h
If Impossible
            mov ah,Detect_Sound_Card
            xor bx,bx
            mov cx,1
            Int_EOS
EndIf


;Ŀ
;Load Module   Load a module into the memory                               
;                                                                          
;In :                                                                      
;        AH = Load_Module                                                  
;        AL = Bit 0 = 1  Load a internal module (can be compress and link  
;                        with LLINK)                                       
;           = Bit 1 = 1  Load modules from memory                          
;           = Bit 2 = 1  Force old mod Loading (15 instr)                  
;        BX = Replay rate for SB (16000 to 441000 Hz)                      
;        DS:EDX = Offset of Module name or                                 
;                 offset into the memory of the beginning of the module    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Can't Load Module                                            
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Load_Module         = 32h
If Impossible
            mov ah,Load_Module
            mov al,4+2+1
            mov bx,22000
            mov edx,O Module_Name
            Int_EOS
            jc Error_Loading_Module
EndIf


;Ŀ
;Play Module   Start playing the module                                    
;                                                                          
;In :                                                                      
;        AH = Play_Module                                                  
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Play_Module         = 34h
If Impossible
            mov ah,Play_Module
            Int_EOS
EndIf


;Ŀ
;Stop Module   Stop playing module                                         
;                                                                          
;In :                                                                      
;        AH = Stop_Module                                                  
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Stop_Module         = 35h
If Impossible
            mov ah,Stop_Module
            Int_EOS
EndIf


;Ŀ
;Clear Module   Unload the module from memory                              
;                                                                          
;In :                                                                      
;        AH = Clear_Module                                                 
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Clear_Module        = 36h
If Impossible
            mov ah,Clear_Module
            Int_EOS
EndIf


;Ŀ
;Set Volume   Set the master volume of the module                          
;                                                                          
;In :                                                                      
;        AH = Set_Volume                                                   
;        BX = Volume (0 to 63)                                             
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Volume          = 3ah
If Impossible
            mov ah,Set_Volume
            mov bx,[New_Volume]
            Int_EOS
EndIf


;Ŀ
;Play Sample   Play a sample include into the module                       
;                                                                          
;In :                                                                      
;        AH = Play_Sample                                                  
;        BX = Numbers of sample                                            
;        CX = Frequecy of sample                                           
;        DX = voice of sample                                              
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Play_Sample         = 3bh
If Impossible
            mov ah,Play_Sample
            mov bx,10
            mov cx,15fh
            mov dx,4
            Int_EOS
EndIf


;Ŀ
;Get Info   Get information about the module when playing                  
;                                                                          
;In:                                                                       
;        AH = Get_Info                                                     
;                                                                          
;Out:                                                                      
;        AH = Position                                                     
;        AL = Pattern                                                      
;        BX = Note                                                         
;        DX = Master Volume                                                
;                                                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Get_Info            = 3eh
If Impossible
            mov ah,Get_Info
            Int_EOS
EndIf


;Ŀ
;Set Pattern  Set the current position of the playing module               
;                                                                          
;In:                                                                       
;        AH = Set_Pattern                                                  
;        BX = New_Position                                                 
;        CX = New_Note                                                     
;                                                                          
;Out:                                                                      
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Pattern         = 3fh
If Impossible
            mov ah,Set_Pattern
            mov bx,[New_Position]
            mov cx,[New_Note]
            Int_EOS
EndIf


;ͻ
;                                                                          
;                     Interrupt & Irq Functions                            
;                                                                          
;ͼ


;Ŀ
;Get_Int       Get protected mode interrupt vector                         
;                                                                          
;In :                                                                      
;        AH = Get_Int                                                      
;        BX = Interrupt number                                             
;                                                                          
;Out :                                                                     
;    CX:EDX = Selector:Offset of interrupt                                 
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Get_Int             = 48h
If Impossible
            mov ah,Get_Int
            mov bx,10h
            Int_EOS
            mov [Old_Int_10_Selector],cx
            mov [Old_Int_10_Offset],edx
EndIf


;Ŀ
;Set_Int       Set protected mode interrupt vector                         
;                                                                          
;In :                                                                      
;        AH = Get_Int                                                      
;        BX = Interrupt number                                             
;    CX:EDX = Selector:Offset of interrupt                                 
;                                                                          
;Out :                                                                     
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Set_Int             = 49h
If Impossible
            mov ah,Set_Int
            mov bx,10h
            mov cx,cs
            mov edx,O New_Int_10
            Int_EOS
EndIf


;Ŀ
;Get_Irq       Get protected mode irq vector                               
;                                                                          
;In :                                                                      
;        AH = Get_Irq                                                      
;        BX = Irq number                                                   
;                                                                          
;Out :                                                                     
;    CX:EDX = Selector:Offset of irq                                       
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Get_Irq             = 4ah
If Impossible
            mov ah,Get_Irq
            mov bx,1h                               ; Keyboard
            Int_EOS
            mov [Old_Irq_01_Selector],cx
            mov [Old_Irq_01_Offset],edx
EndIf


;Ŀ
;Set_Irq       Set protected mode irq vector                               
;                                                                          
;In :                                                                      
;        AH = Get_Irq                                                      
;        BX = Irq number                                                   
;    CX:EDX = Selector:Offset of irq                                       
;                                                                          
;Out :                                                                     
;                                                                          
;Autre Registre Modifie : Aucun                                            
;                                                                          
;                                                                          
;
Set_Irq             = 4bh
If Impossible
            mov ah,Set_Irq
            mov bx,1h                               ; Keybord
            mov cx,cs
            mov edx,O New_Irq_01
            Int_EOS
EndIf


;ͻ
;                                                                          
;                           Memory Allocation                              
;                                                                          
;ͼ


;Ŀ
;Allocate Memory   Allocate Upper memory                                   
;                                                                          
;In :                                                                      
;        AH = Allocate_Memory                                              
;       EDX = Size of memory block to allocate in bytes                    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       EAX = Physical address of the block (work with Zero_Sel)           
;       EDX = Logical address of the block (work with Data32_Sel)          
;                                                                          
;        Carry = 1                                                         
;             Can't allocate memory                                        
;       EAX = Memory size avaible                                          
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Allocate_Memory   = 40h
If Impossible
            mov ah,Allocate_Memory
            mov edx,[Allocation_Size]
            Int_EOS
            jc Not_Enough_Memory
            mov [Physical_Address_Of_Block],eax     ; Work with Zero_Sel
            mov [Logical_Address_Of_Block],edx      ; Work with Data32_Sel
EndIf


;Ŀ
;DeAllocate Memory   Free the last allocate memory                         
;                                                                          
;In :                                                                      
;        AH = DeAllocate_Memory                                            
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
DeAllocate_Memory = 41h
If Impossible
            mov ah,DeAllocate_Memory
            Int_EOS
EndIf


;Ŀ
;Allocate Selector   Create a new selector (type Data32_Sel)               
;                                                                          
;In :                                                                      
;        AH = Allocate_Selector                                            
;       ESI = Physical base address of the new selector                    
;       EDI = Size of the new selctor module 4096                          
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;        BX = New selector                                                 
;                                                                          
;        Carry = 1                                                         
;             Can't create selector                                        
;                                                                          
;Other Registers Change : EAX                                              
;                                                                          
;                                                                          
;
Allocate_Selector   = 42h
If Impossible
            mov ah,Allocate_Selector
            mov esi,0a0000h
            mov edi,0fh         ; 64ko (0000-ffff)
            Int_EOS
            jc No_Free Selector
            mov [_0a0000h_Sel],bx
EndIf


;Ŀ
;DeAllocate Selector   Free a Selector                                     
;                                                                          
;In :                                                                      
;        AH = DeAllocate_Selector                                          
;        BX = Selector                                                     
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Can't deallocate selector                                    
;                                                                          
;Other Registers Change :  EAX,EBX                                         
;                                                                          
;                                                                          
;
DeAllocate_Selector = 43h
If Impossible
            mov ah,DeAllocate_Selector
            mov bx,[_0a0000h_Sel]
            Int_EOS
            jc Invalid_Selector
EndIf


;ͻ
;                                                                          
;                      Monochrome Display                                  
;                                                                          
;ͼ


;Ŀ
;Set Mono   Force On/Off the display of all the Monochrome Function        
;                                                                          
;In :                                                                      
;        AH = Set_Mono                                                     
;        BX = On  Force Monochrome Off                                     
;             Off Force Monochrome On                                      
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Mono            = 0e0h
If Impossible
            mov ah,Set_Mono
            mov bx,On
            Int_EOS
EndIf


;Ŀ
;Set String Mono   Display a string on the Monochrome adapter              
;                                                                          
;In :                                                                      
;        AH = Set_String_Mono                                              
;        BX = Coordonate  X                                                
;        CX = Coordonate  Y                                                
;       EDX = Address of text ending by $                                  
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_String_Mono     = 0e1h
If Impossible
            mov ah,Set_String_Mono
            mov bx,1
            mov cx,10
            mov edx,offset text_mono
            Int_EOS
EndIf


;Ŀ
;Set Value Mono   Display A Word in Hexadecimal on the Monochrome adapter  
;                                                                          
;In :                                                                      
;        AH = Set_Value_Mono                                               
;        BX = Coordonate X                                                 
;        CX = Coordonate Y                                                 
;        EDX = Value to be display                                         
;                                                                          
;                                                                          
;Out :                                                                     
;                                                                          
;Other Registers Change : None                                             
;                                                                          
;                                                                          
;
Set_Value_Mono      = 0e2h
If Impossible
            mov ah,Set_Value_Mono
            mov bx,1
            mov cx,10
            mov dx,1234h
            Int_EOS
EndIf


;ͻ
;                                                                          
; EOS Library                                                              
;                                                                          
;ͼ


;ͻ
;                                                                          
; VESA                                                                     
;                                                                          
;ͼ

Global Init_Vesa            : Proc
Global Set_Bank             : Proc
Global Next_Bank            : Proc
Global Vesa_Current_Bank    : Byte

Global Init_Vesa_Bank       : Proc
Global Close_Vesa_Bank      : Proc

Global Vesa_Clear_Palette   : Byte

; ------------ VBE v1.0  ------------------
Mode640x400x256             = 100h
Mode640x480x256             = 101h
Mode800x600x16              = 102h
Mode800x600x256             = 103h
Mode1024x768x16             = 104h
Mode1024x768x256            = 105h
Mode1280x1024x16            = 106h
Mode1280x1024x256           = 107h
Mode80x60                   = 108h
Mode132x25                  = 109h
Mode132x43                  = 10ah
Mode132x60                  = 10bh
Mode132x60                  = 10ch
; ------------ VBE v1.2+ ------------------
Mode320x200x32k             = 10dh
Mode320x200x64k             = 10eh
Mode320x200x16M             = 10fh
Mode640x480x32k             = 110h
Mode640x480x64k             = 111h
Mode640x480x16M             = 112h
Mode800x600x32k             = 113h
Mode800x600x64k             = 114h
Mode800x600x16M             = 115h
Mode1024x768x32k            = 116h
Mode1024x768x64k            = 117h
Mode1024x768x16M            = 118h
Mode1280x1024x32k           = 119h
Mode1280x1024x64k           = 11ah
Mode1280x1024x16M           = 11bh

;Ŀ
;Init Vesa   Initialize A Vesa video mode                                  
;                                                                          
;In :                                                                      
;        AX = Vesa mode                                                    
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;                                                                          
;        Carry = 1                                                         
;             Mode Vesa not supported or Vesa driver not found             
;                                                                          
;
If Impossible
            mov ax,Mode640x480x256
            call Init_Vesa
            jc Error_Vesa

            ...

Vesa_Txt            db '     Mode SVGA not supported or VESA not found !',13,10
                    db '      To install a vesa driver, refer to your video card documentation.',13,10,36
EndIf


;Ŀ
;Init Vesa Bank  Init the Automatic Bank Switching                         
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;        Carry = 0                                                         
;             All Done                                                     
;       BX = New selector for addressing the video ram                     
;                                                                          
;        Carry = 1                                                         
;             Can't allocate selector                                      
;                                                                          
;
If Impossible
            call Init_Vesa_Bank
            jc Error_Sel
            mov [screen_selector],bx

            ...

            mov edx,edi     ; EDI Address of first pixel to be display
            shr edx,16
            call Set_Bank
            and edi,0ffffh

            ...

            call Close_Vesa_Bank
EndIf


;ͻ
;                                                                          
; FLI32                                                                    
;                                                                          
;ͼ

Global Load_Fli             : Proc
Global Load_Internal_Fli    : Proc
Global Dispose_Fli          : Proc

Global First_Frame_Fli      : Proc
Global Next_Frame_Fli       : Proc

Global Fli_Err              : Byte
Global Fli_Svga             : Byte
Global Fli_Swap             : Byte

Global Fli_ReStart          : Byte
Global Fli_Loop             : Byte
Global Fli_TrackDisk        : Byte
Global Fli_Last_Frame       : Byte

Global Fli_Delay            : Dword
Global Fli_Buffer           : Dword

;Ŀ
;Play a FLI/FLC files                                                      
;                                                                          
;Procedures :                                                              
;                                                                          
;        Load_Fli          Load a FLI intro the memory                     
;                          Initialize if needed the track-disk mode        
;                          check the header                                
;                                                                          
;        Load_Internal_Fli Load a FLI which is link with LLINK             
;                          check the header                                
;                                                                          
;        First_Frame_Fli   Uncompress the first frame                      
;                                                                          
;        Next_Frame_Fli    Uncompress next frame                           
;                                                                          
;        Dispose_Fli       Freeing memory                                  
;                          Close File                                      
;                                                                          
;Information During playing :                                              
;                                                                          
;        Fli_Err       = 1 - Chunk not found                               
;                        2 - Out of memory                                 
;                        3 - File error                                    
;                        4 - Bad FLC header                                
;                        5 - Size max for FLC : 640x480                    
;                                                                          
;        Fli_Swap      = On - Track disk  runnig not enough memory to load 
;                             all the file                                 
;                        Off- File has been load into memory               
;                                                                          
;        Fli_Svga      = On - Numbers of Ligne >200                        
;                                                                          
;        Fli_Delay     = Fli speed                                         
;                                                                          
;        Fli_Last_Frame= On - Last frame (Mode No looping)                 
;                                                                          
;Commandes :                                                               
;                                                                          
;        Fli_ReStart   = On - Restart at the begining of the animation     
;                                                                          
;        Fli_Loop      = On - Restart the FLI at the end (Defaults)        
;                        Off- Stop at the end  (Mode No looping)           
;                                                                          
;        Fli_TrackDisk = On - Enable Track-Disk mode                       
;                        Off- Track-Disk not use execpt when the FLI can't 
;                             be load into the memory                      
;                                                                          
;        Fli_Buffer    = Logical address of FLI buffer                     
;                                                                          
;
If Impossible
           mov edx, offset Fli_Path
         call Load_Fli
        jc Fli_Error

            cmp Fli_Svga,On
            je  @@Init_Svga
            jne @@Init_Vga

            ...

            mov es,[screen_selector]

            call First_Frame_Fli
            jc Fli_Error

@@again:
            mov ah,Wait_Vbl
            Int_EOS

            call Next_Frame_Fli
            jc Fli_Error

            cmp Key_Map[Escape],On
            jne @@again
endif


;ͻ
;                                                                          
; SNAP                                                                     
;                                                                          
;ͼ

;Ŀ
;Snap        Capture une image en 256 couleurs non mode X et la sauve en   
;            IFF                                                           
;            Touche d'action Arret Defil                                   
;

;Ŀ
;Init Snap   Initialize the screen grabber . (You can change the int 09    
;            function Use_Int_09 after this Init                           
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Init_Snap    : Proc


;Ŀ
;Snap IFF    Grab the current Screen from Video RAM                        
;                                                                          
;In :                                                                      
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Snap_IFF     : Proc


;Ŀ
;Save IFF    Save a buffer to IFF                                          
;                                                                          
;In :                                                                      
;        AX = Screen Size X                                                
;        BX = Screen Size Y                                                
;       EDX = Offset of File Name                                          
;       ESI = Address to save in IFF                                       
;                                                                          
;Out :                                                                     
;                                                                          
;

Global Save_IFF     : Proc


;ͻ
;                                                                          
; Macros used for calling the real mode                                    
;                                                                          
;ͼ

Global     Real_GS                 :dword
Global     Real_FS                 :dword
Global     Real_DS                 :dword
Global     Real_ES                 :dword
Global     Real_SS                 :dword
Global     Real_SP                 :dword

DosInt     macro Int_Number
            push Int_Number
            int 32h
           endm

DosCALL    macro _Seg_,_Ofs_
           IFB <_Ofs_>
            push D _Seg_
           ELSE
            push W _Seg_
            push W _Ofs_
           ENDIF
            int 33h
           endm

Init_es_di  macro Adrs
            mov edi,[code32_addr]
            add edi,O Adrs
            shr edi,4
            mov real_es,edi
            lea edi,Adrs
            and edi,0fh
            endm

Init_ds_dx  macro Adrs
            mov edx,[code32_addr]
            add edx,O Adrs
            shr edx,4
            mov real_ds,edx
            lea edx,Adrs
            and edx,0fh
            endm


;ͻ
;                                                                          
; Miscellaneous                                                            
;                                                                          
;ͼ


Global       CODE32_sel              :word
Global       DATA32_sel              :word
Global       Zero_sel                :word
Global       Environment_addr        :dword
Global       PSP_addr                :dword
Global       _0b0000h                :dword
Global       _0b8000h                :dword
Global       _0a0000h                :dword
Global       Code32_Addr             :dword
Global       Zero_Addr               :dword
Global       Start32                 :proc
Global       Server_Type             :Byte

;ͻ
;                                                                          
; The 32bit debugger                                                       
;                                                                          
;ͼ

Global       Debug                   :proc